class RandomGenerator < Generator
  def initialize(attack, use_evasions, ignore_evasions)
    super(attack, use_evasions, ignore_evasions)
    if @use_evasions.size > 0
      @percentage = (1.0 / @use_evasions.size)
    else
      @percentage = (1.0 / (@attack.evasions.size - @ignore_evasions.size))
    end
  end

  def generate(index)
    while(true)
      configured_evasion = {}
      @attack.evasions.each do |evasion|
        next if @use_evasions.size > 0 and not @use_evasions.include?(evasion.base_name)
        next if @ignore_evasions.has_key?(evasion.base_name)
        r = rand
        if r < @percentage
          option_hash = {}
          evasion.options.each do |option|
            value = option.get_value(rand(option.get_enum_size()))
            option_hash[option.name] = value
          end
          next if not valid_evasion?(evasion, option_hash)
          configured_evasion[evasion] = option_hash
        end
      end
      if valid_combo?(configured_evasion)
        return configured_evasion 
      end
    end
  end

  def to_s
    return "Random evasions generator (Evasion adding percentage is #{@percentage})"
  end
end
