/*
#
#   Copyright (C) Stonesoft Corporation 2010 - 2011.
#   All rights reserved.
#
#   The StoneGate software, manuals, and technical
#   literature may not be reproduced in any form or
#   by any means except by permission in writing from
#   Stonesoft Corporation.
#
*/

document.write('<script type="text/javascript" src="script/evasions.js"></script>');

var current_host_config = null;
var current_network_config = null;
var current_exploit = null;
var current_preset = null;

var in_command_shell = false;
var command_shell_refresh_id = null;
var log_offset = 0;
var session_id = Math.floor( Math.random() * 1000000 );


function Exploit()
{
    // Gather all configuration and send a request
    var network_url = "";
    var evasion_url = "";
    var attack_url = "";
    var close_shell_url = "";
    var i, option, elem_name, selected_elem;

    // Build network setup
    if( current_network_config == null && current_host_config == null )
    {
        // Got no network configurations, must be in 'writable' mode
        iface_elem = document.getElementById( "netconfig_iface" )
        srcip_elem = document.getElementById( "netconfig_src_ip" )
        dstip_elem = document.getElementById( "netconfig_dst_ip" )
        gateway_elem = document.getElementById( "netconfig_gateway" )

        if( iface_elem == null || srcip_elem == null || dstip_elem == null || gateway_elem == null )
        {
            alert( "Writable elements missing" );
            return;
        }

        network_url = "&net_cfg_type=writable"
        if( iface_elem.value != "" )
            network_url += "&netconfig_iface="+iface_elem.value

        if( srcip_elem.value != "" )
            network_url += "&netconfig_src_ip="+srcip_elem.value

        if( dstip_elem.value != "" )
            network_url += "&netconfig_dst_ip="+dstip_elem.value

        if( gateway_elem.value != "" )
            network_url += "&netconfig_gateway="+gateway_elem.value
    }
    else
    {
        // Got network configurations!
        network_url = "&net_cfg_type=preset" +
                      "&network_config=" + current_network_config +
                      "&host_config=" + current_host_config
    }

    // Build attack setup
    if( current_exploit == null )
    {
        alert( "No attack selected!" );
        return;
    }
    attack_url = "attack=" + current_exploit;
    
    // Build mongbat/evasion setup
    mode = document.getElementById( 'mode' ).value
    mode_url = null
    if( mode == 'mode_mongbat' )
    {
        mongbat_url = "&mode=mongbat"

        mong_mode = document.getElementById( "mongbat_mode" ).value
        mong_workers = document.getElementById( "mongbat_workers" ).value
        mong_time = document.getElementById( "mongbat_time" ).value
        mong_minev = document.getElementById( "mongbat_min_evasions" ).value
        mong_maxev = document.getElementById( "mongbat_max_evasions" ).value
        
        mongbat_url += "&mongbat_mode=" +       mong_mode +
                       "&mongbat_workers=" +    mong_workers +
                       "&mongbat_time=" +       mong_time +
                       "&mongbat_minev=" +      mong_minev +
                       "&mongbat_maxev=" +      mong_maxev;
                       
        mode_url = mongbat_url
    }
    else if( mode == 'mode_presets' )
    {
        preset_url = "&mode=presets"

        preset_name = document.getElementById( "evasion_presets" ).value

        preset_url += "&preset_name=" + preset_name;

        mode_url = preset_url
    }
    else if( mode == 'mode_evasions' )
    {
        evasion_url = ""
        for( var elem in evasion_arr )
        {
            checkbox = document.getElementById( elem + "_checkbox" );
            if( checkbox == null )
            {
                //alert( "Checkbox " + elem + " not found!" );
                continue;
            }

            if( checkbox.checked )
            {
                evasion_url += elem + "->";

                // Checked evasion
                for( i=0; i<evasion_opt_arr[ elem ].length; ++i )
                {

                    option = evasion_opt_arr[ elem ][ i ];
                    elem_name = elem + "::" + option[ "name" ];

                    if( ( option[ 0 ] == "integer" ) || ( option[ 0 ] == "probability" ) )
                    {
                        // Integers must always be sent
                        selected_elem = document.getElementById( elem_name );
                        if( selected_elem == null )
                            alert( "Could not find Integer selected_elem " + option[ "name" ] );

                        evasion_url += elem_name + "=" + selected_elem.value + ",";
                    }
                    else if( option[ 0 ] == "choice" )
                    {
                        // Find all checked options and send them
                        for( j=1; j<option.length; ++j )
                        {
                            choice_name = elem_name + "::" + option[ j ][ "name" ] + "_checkbox";
                            selected_elem = document.getElementById( choice_name );
                            if( selected_elem == null )
                                alert( "Could not find choice element: " + choice_name + "::" + option[ j ][ "name" ] + "_checkbox" );

                            if( selected_elem.checked )
                                evasion_url += elem_name + "="+option[ j ][ "name" ] + ",";
                        }
                    }
                    else
                    {
                        alert( "Unknown option type: " + option[ 0 ] );
                        return;
                    }
                }
                evasion_url += "___";
            }
        }
        evasion_url = "&mode=evasions&evasions=" +  escape( evasion_url );
        mode_url = evasion_url
    }

    // Build 'automatically close shell' thing
    close_shell_url = "&auto_close_shell=" + AutomaticallyCloseShellSet();
    clean_url = "&clean=" + CleanSet();

    extra_url = ""

    // Set extra options
    for( elem in exploit_arr[ current_exploit ][ "extra_options" ] )
    {
        elem_name = exploit_arr[ current_exploit ][ "short_name" ] + "_" + exploit_arr[ current_exploit ][ "extra_options" ][ elem ]
        opt_elem = document.getElementById( elem_name )
        if( opt_elem == null )
        {
            alert( "Missing element " + elem_name )
            return;
        }

        if( opt_elem.type == "text" )
        {
            if( opt_elem.value != "" )
            {
                extra_url += exploit_arr[ current_exploit ][ "extra_options" ][ elem ] + "=" + opt_elem.value
                extra_url += "___"
            }
        }
        else if( opt_elem.type == "checkbox" )
        {
            if( opt_elem.checked )
            {
                extra_url += exploit_arr[ current_exploit ][ "extra_options" ][ elem ] + "=true"
                extra_url += "___"
            }
        }
        else
        {
            alert( "Unknown element type in extra element: " + opt_elem.type )
            return;
        }

        
    }
    
    // Combine and send
    var request_params = network_url + mode_url + "&" +
                         attack_url + "&" + close_shell_url + clean_url;

    if( extra_url != "" )
    {
        extra_url = "&extra_options=" + extra_url
        request_params += extra_url
    }
    
    $.ajax( { url: "/exploit/run",
             data: request_params
           }
         );
}

function StopExploit()
{
   $.ajax( { url: "/exploit/stop" } );
}

function OpenShell()
{
   $.colorbox( { title: "Command Shell",
                 href: "/shell/reader_html",
                 onComplete: function() { in_command_shell = true; },
                 onCleanup: function() { CloseShell(); in_command_shell = false; }
               } );
}

function CloseShell()
{
   // Send shell closing command   
   $.ajax( { url: "/shell/close"
           })
   if( command_shell_refresh_id != null )
   {
      clearInterval( command_shell_refresh_id )
      command_shell_refresh_id = null;
   }
}

// Return true if 'run combinations' checkbox is ticked
function RunCombinationsSet()
{
    var comb_elem = document.getElementById( "global_do_combinations" );
    return comb_elem.checked
}

// Return true if 'automatically close shell' checkbox is ticked
function AutomaticallyCloseShellSet()
{
    var comb_elem = document.getElementById( "global_auto_close_shell" );
    return comb_elem.checked
}

// Return true if 'clean' checkbox is ticked
function CleanSet()
{
    var clean_elem = document.getElementById( "global_clean" );
    return clean_elem.checked
}

// Read a number from a 'text' input field
function GetNumberFromTextInput( tag_id )
{
    var input_elem = document.getElementById( tag_id )
    var iter_value = parseInt( input_elem.value )

    if( iter_value == "NaN" )
        return 1
    return iter_value
}

// Return the number in 'number of executions', or 1 for empty
function GetNumberOfExecutions()
{
    return GetNumberFromTextInput( "iterations" )
}

function GetFirstIndex()
{
    return GetNumberFromTextInput( "first_index" )
}

function GetRandomSeed()
{
    return GetNumberFromTextInput( "random_seed" )
}

function KeyboardEvent( e )
{
   if( in_command_shell == true )
   {
      // Don't do anything while not in a command shell.
      var evt = e || window.event;
      var code = 0;
      
      if( evt.keyCode == 0 && evt.charCode == 0 )
         alert( "Keypress, both keyCode and charCode are 0 - internal error" );
      else if( evt.keyCode != 0 )
         code = evt.keyCode;
      else
         code = evt.charCode;
      
      // Send the key code over
      $.ajax( { url: "/shell/write",
                data: "input=" + code + "&session_id=" + session_id,
                dataType: "text",
                success: function( data ) {
                  if( data.length > 0 )
                  {
                    var new_log = $('.command_shell').html() + data;
                    $('.command_shell').html( new_log );
                  }
                }
              })
   }
}

function Construct()
{
   document.getElementById( 'exploits' ).selectedIndex = 0;
   ExploitChanged();
   ModeChanged();
   EvasionPresetChanged();

   
   network_config_elem = document.getElementById( 'network_config' )
   host_config_elem = document.getElementById( 'host_config' )
   
   if( network_config_elem != null && host_config_elem != null )
   {
      network_config_elem.selectedIndex = 0;
      host_config_elem.selectedIndex = 0;
      NetworkConfigChanged();
   }
            
   ClearEvasions();
   
   document.onkeypress=KeyboardEvent;
}

function ClearLogs()
{
   $.ajax( { url: "/clear_logs"
           })
   $( '.log' ).html( "" );
}

function ClearEvasions()
{
   for( var elem in evasion_iface_arr )
   {
      checkbox = document.getElementById( elem + "_checkbox" );
      if( checkbox == null )
      {
         alert( "Element " + elem + "_checkbox not found!" )
         return
      }
      
      checkbox.checked = false;
   }
   
   for( var elem in evasion_arr )
   {
      checkbox = document.getElementById( elem + "_checkbox" );
      if( checkbox == null )
      {
         alert( "Element " + elem + "_checkbox not found!" )
         return
      }
      
      checkbox.checked = false;
      
      for( var i=0; i<evasion_opt_arr[ elem ].length; i++ )
      {
         option = evasion_opt_arr[ elem ][ i ]


         if( option[ 0 ] == "choice" && option[ "single" ] == false )
         {
            var option_name = option[ "name" ]
            // Uncheck checkboxes
            for( var j=1; j<option.length; j++ )
             {
                var choice_name = option[ j ][ "name" ]
                var selected_elem_id = elem + "::" + option_name + "::" + choice_name + "_checkbox";
                var selected_elem = document.getElementById( selected_elem_id );

                if( selected_elem != null )
                   selected_elem.checked = false;
                else
                   alert( "Could not find evasion " + selected_elem_id )
             }
         }
      }
   }
}

function ClearEvasionsByIface( iface_name )
{
	checkbox = document.getElementById( iface_name + "_checkbox" );
	if( checkbox == null )
		return;
	checkbox.checked = false;
	
	for( var elem in evasion_arr )
	{
		if( elem.indexOf( iface_name ) == -1 )
			continue;
		
		
		checkbox = document.getElementById( elem + "_checkbox" );
		if( checkbox == null )
			return;
		
		checkbox.checked = false;
		for( var i=0; i<evasion_opt_arr[ elem ].length; ++i )
		{
			option = evasion_opt_arr[ elem ][ i ]
			if( option[ 0 ] == "choice" && option[ "single" ] == false )
			{
	            var option_name = option[ "name" ]
	            // Uncheck checkboxes
	            for( var j=1; j<option.length; j++ )
	             {
	                var choice_name = option[ j ][ "name" ]
	                var selected_elem_id = elem + "::" + option_name + "::" + choice_name + "_checkbox";
	                var selected_elem = document.getElementById( selected_elem_id );

	                if( selected_elem != null )
	                   selected_elem.checked = false;
	                else
	                   alert( "Could not find evasion " + selected_elem_id )
	             }
	         }		
		}
	}	
}

function DoNothing( object )
{
}


function NetworkConfigChanged()
{
   var select_elem = document.getElementById( 'network_config' )
   var selected_index = select_elem.selectedIndex;
   var selected_id = select_elem.options[ selected_index ].id
   var net_config = network_config_arr[ selected_id ]
   
   current_network_config = selected_id
   
   select_elem = document.getElementById( 'host_config' )
   selected_index = select_elem.selectedIndex;
   selected_id = select_elem.options[ selected_index ].id
   var host_config = host_config_arr[ selected_id ]
      
   current_host_config = selected_id
   
   var correct_ip = null   
   var src_ip = null
   
   if( net_config[ "dst_ipv4" ] != null )
   {
	   // IPv4
	   src_ip = net_config[ "src_ipv4" ]
	   correct_ip = net_config[ "dst_ipv4" ].substring( 0, net_config[ "dst_ipv4" ].length - 1 )
	   correct_ip += host_config.ipv4_end	   
   }
   else if( net_config[ "dst_ipv6" ] != null )
   {
	   // IPv6
	   src_ip = net_config[ "src_ipv6" ]
	   correct_ip = net_config[ "dst_ipv6" ].substring( 0, net_config[ "dst_ipv6" ].length - 4 )
	   correct_ip += host_config.ipv6_end   
   }
	
   document.getElementById( 'netconfig_name' ).innerHTML = net_config[ 'name' ]
   document.getElementById( 'netconfig_iface' ).innerHTML = net_config[ 'iface' ]
   document.getElementById( 'netconfig_gateway' ).innerHTML = net_config[ 'gateway' ]
   document.getElementById( 'netconfig_src_ip' ).innerHTML = src_ip
   document.getElementById( 'netconfig_src_mask' ).innerHTML = net_config[ 'src_mask' ]
   document.getElementById( 'netconfig_src_mac' ).innerHTML = net_config[ 'src_mac' ]
   document.getElementById( 'netconfig_dst_ip' ).innerHTML = correct_ip
   document.getElementById( 'netconfig_dst_mask' ).innerHTML = net_config[ 'dst_mask' ]
   
   ExploitChanged()	// Called for IPv4 / IPv6 changes
}

function ExploitChanged()
{
   var selected_index = document.getElementById( 'exploits' ).selectedIndex;
   var selected_id = document.getElementById( 'exploits' ).options[ selected_index ].id
   var config = exploit_arr[ selected_id ]
   
   var select_network_elem = document.getElementById( 'network_config' )
   var net_config = null
   if( select_network_elem != null )
   {
	   var selected_network_index = select_network_elem.selectedIndex;
	   var selected_network_id = select_network_elem.options[ selected_network_index ].id
	   net_config = network_config_arr[ selected_network_id ]
   }
        
   current_exploit = selected_id
   
   document.getElementById( 'exploit_name' ).innerHTML = config[ 'name' ]
   document.getElementById( 'exploit_cve' ).innerHTML = config[ 'cve' ]
   document.getElementById( 'exploit_description' ).innerHTML = config[ 'description' ]

   for( var elem in evasion_iface_arr )
   {
      if( config[ "evasion_ifaces" ].indexOf( elem ) == -1 )
      {
         HideEvasionElement( elem )
      }
      else if( net_config != null )
      {
    	  if( elem == 'ipv6' && net_config[ 'src_ipv6' ] == null )
    	  {
    		  HideEvasionElement( elem )
    		  ClearEvasionsByIface( elem )
    	  }
		  else if( elem == 'ipv4' && net_config[ 'src_ipv4' ] == null )
		  {
			  HideEvasionElement( elem )
			  ClearEvasionsByIface( elem )
		  }
		  else
			  ShowEvasionElement( elem )
      }
      else
	  {
    	  ShowEvasionElement( elem )
	  }
   }

   for( var elem in exploit_arr )
      HideExploitOptions( elem )
   ShowExploitOptions( config[ "short_name" ] )
}

function ModeChanged()
{
    var selected_index = document.getElementById( 'mode' ).selectedIndex;
    var selected_id = document.getElementById( 'mode' ).options[ selected_index ].value;
    MongbatModeChanged();

    if( selected_id == 'mode_mongbat' )
    {
        document.getElementById( 'mongbat_bg' ).style.display = "block";
        document.getElementById( 'evasion_bg' ).style.display = "none";
        document.getElementById( 'preset_bg' ).style.display = "none";

        EnableExploitSelection();
        DisableAutomaticallyCloseShell();
        DisableSendCleanPayload();
    }
    else if( selected_id == 'mode_evasions' )
    {
        document.getElementById( 'mongbat_bg' ).style.display = "none";
        document.getElementById( 'evasion_bg' ).style.display = "block";
        document.getElementById( 'preset_bg' ).style.display = "none";

        EnableExploitSelection();
        EnableAutomaticallyCloseShell();
        EnableSendCleanPayload();
    }
    else if( selected_id == 'mode_presets' )
    {
        document.getElementById( 'mongbat_bg' ).style.display = "none";
        document.getElementById( 'evasion_bg' ).style.display = "none";
        document.getElementById( 'preset_bg' ).style.display = "block";

        DisableExploitSelection();
        DisableAutomaticallyCloseShell();
        DisableSendCleanPayload();
    }
    else
    {
        alert( "ModeChanged() - Invalid selection: " + selected );
    }
}

function MongbatModeChanged()
{
    var selected_id = document.getElementById( 'mongbat_mode' ).value;

    if( selected_id == 'solo' || selected_id == 'dual' )
    {
        document.getElementById( 'mongbat_determ' ).style.display = "block";
        document.getElementById( 'mongbat_random' ).style.display = "none";
    }
    else if( selected_id == 'random' )
    {
        document.getElementById( 'mongbat_determ' ).style.display = "none";
        document.getElementById( 'mongbat_random' ).style.display = "block";
    }
    else
    {
        alert( "MongbatModeChanged() - Invalid selection: " + selected_id );
    }
}

function EvasionPresetChanged()
{
    var selected_id = document.getElementById( 'evasion_presets' ).value;
    var config = preset_arr[ selected_id ]
    if( config == null )
    {
        alert( "Invalid preset " + selected_id + " selected!" );
        return;
    }

    document.getElementById( 'preset_desc' ).innerHTML = config[ "desc" ];
    document.getElementById( 'preset_size' ).innerHTML = config[ "size" ];

    // Select the correct exploit
    SelectExploit( config[ "attack" ] );
}

function EVTreeIsOpen( elem )
{
   for( var i=0; i<elem.childNodes.length; i++ )
   {
      if( elem.childNodes[ i ].tagName == "UL" )
      {
         child_ul = elem.childNodes[ i ]
         for( var j=0; j<child_ul.childNodes.length; j++ )
         {
            if( child_ul.childNodes[ j ].className == "evtree-closed" || 
                child_ul.childNodes[ j ].className == "evtree-leaf-closed" )
            {
               return false;
            }
            else if( child_ul.childNodes[ j ].className == "evtree-open" || 
                     child_ul.childNodes[ j ].className == "evtree-leaf-open" )
            {
               return true;
            }
         }
      }
   }
   return false;
}

function EVTreeOpenNode( li_elem )
{
   for( var i=0; i<li_elem.childNodes.length; i++ )
   {
      if( li_elem.childNodes[ i ].tagName == "UL" )
      {
         child_ul = li_elem.childNodes[ i ];
         for( var j=0; j<child_ul.childNodes.length; j++ )
         {
            if( child_ul.childNodes[ j ].className == "evtree-closed" )
            {
               child_ul.childNodes[ j ].className = "evtree-open";
            }
            else if( child_ul.childNodes[ j ].className == "evtree-leaf-closed" )
            {
               leaf_node = child_ul.childNodes[ j ]
               leaf_node.className = "evtree-leaf-open"
               
               for( var k=0; k<leaf_node.childNodes.length; k++ )
               {
                  if( leaf_node.childNodes[ k ].tagName == "UL" )
                  {
                     leaf_ul_node = leaf_node.childNodes[ k ]
                     
                     for( var l=0; l<leaf_ul_node.childNodes.length; l++ )
                     {
                        leaf_li_node = leaf_ul_node.childNodes[ l ]
                        if( leaf_li_node.className == "evtree-leaf-closed" )
                           leaf_li_node.className = "evtree-leaf-open";
                     }
                  }
               }
            }
         }
      }
   }
}

function EVTreeCloseNode( li_elem )
{
   for( var i=0; i<li_elem.childNodes.length; i++ )
   {
      if( li_elem.childNodes[ i ].tagName == "UL" )
      {
         child_ul = li_elem.childNodes[ i ];
         for( var j=0; j<child_ul.childNodes.length; j++ )
         {
            if( child_ul.childNodes[ j ].className == "evtree-open" )
            {
               child_ul.childNodes[ j ].className = "evtree-closed";
            }
            else if( child_ul.childNodes[ j ].className == "evtree-leaf-open" )
            {
               leaf_node = child_ul.childNodes[ j ]
               leaf_node.className = "evtree-leaf-closed"
               
               for( var k=0; k<leaf_node.childNodes.length; k++ )
               {
                  if( leaf_node.childNodes[ k ].tagName == "UL" )
                  {
                     leaf_ul_node = leaf_node.childNodes[ k ]
                     
                     for( var l=0; l<leaf_ul_node.childNodes.length; l++ )
                     {
                        leaf_li_node = leaf_ul_node.childNodes[ l ]
                        if( leaf_li_node.className == "evtree-leaf-open" )
                           leaf_li_node.className = "evtree-leaf-closed";
                     }
                  }
               }
            }
         }
      }
   }
}

function EVTreeCheckboxClicked( checkbox_id )
{
   // - If we are not checked before click
   //    -> Mark the whole path to root as checked
   // - If we are checked
   //    -> Mark the path to root as unchedked upto the point where siblings are also unchecked
   
   var checkbox_elem = document.getElementById( checkbox_id )
   var parent_ul = checkbox_elem.parentNode.parentNode
   if( checkbox_elem.checked == true )
   {
      // Note, checked status is changed *before* this function gets called -> checked now means we weren't checked'
      if( parent_ul.tagName == "UL" )
      {
         if( parent_ul.parentNode.tagName == "LI" )
         {
            // We should be in the iface now
            parent_iface_li = parent_ul.parentNode
            
            // Find the _checkbox
            for( var i=0; i<parent_iface_li.childNodes.length; i++ )
            {
               if( parent_iface_li.childNodes[ i ].tagName == "INPUT" )
               {
                  parent_checkbox = parent_iface_li.childNodes[ i ]
                  if( parent_checkbox.checked != true )
                     parent_checkbox.checked = true;
               }
            }
         }
         else
         {
            // We should be past the iface now, do nothing
         }
      }
   }
   else
   {
      // Checkbox was checked -> uncheck parent if nobody else is checked
      
      // Note, checked status is changed *before* this function gets called -> checked now means we weren't checked'
      if( parent_ul.tagName == "UL" )
      {
         if( parent_ul.parentNode.tagName == "LI" )
         {
            // We should be in the iface now
            parent_iface_li = parent_ul.parentNode
            
            // Check siblings, if some are yet checked we do nothing
            for( var i=0; i<parent_ul.childNodes.length; i++ )
            {
               child_li = parent_ul.childNodes[ i ]
               for( var j=0; j<child_li.childNodes.length; j++ )
               {
                  if( child_li.childNodes[ j ].tagName == "INPUT" )
                  {
                     child_box = child_li.childNodes[ j ]
                     if( child_box.checked == true )
                        return;  // Got checked children, nothing to do
                  }
               }
            }
            
            // Getting here means nobody is checked, find parent checkbox and uncheck it
            for( var i=0; i<parent_iface_li.childNodes.length; i++ )
            {
               if( parent_iface_li.childNodes[ i ].tagName == "INPUT" )
               {
                  parent_checkbox = parent_iface_li.childNodes[ i ]
                  if( parent_checkbox.checked == false )
                  {
                     alert( "Somehow got unchecked parent box" )
                     return;
                  }
                  parent_checkbox.checked = false;
                  return;
               }
            }
            
         }
      }
   }
}

function EVTreeToggle( div_id )
{
   var li_name = div_id + "_li";
   var checkbox_name = div_id + "_checkbox";
   
   var li_elem = document.getElementById( li_name )
   var checkbox_elem = document.getElementById( checkbox_name )
   
   if( EVTreeIsOpen( li_elem ) )
   {
      // Node is open - close it!
      EVTreeCloseNode( li_elem )
   }
   else
   {
      EVTreeOpenNode( li_elem )
   }
}

function ToggleDiv( div_id, marker_id )
{
   var elem = document.getElementById( div_id );
   var marker_elem = document.getElementById( marker_id );
   
   if( elem.style.display == '' && elem.offsetWidth != undefined && elem.offsetHeight != undefined )
      elem.style.display = ( elem.offsetWidth != 0 && elem.offsetHeight != 0 ) ? 'block' : 'none';

   if( elem.style.display == '' || elem.style.display == 'block' )
   {
      elem.style.display = 'none';
      marker_elem.innerHTML = "+&nbsp;";
   }
   else
   {
      elem.style.display = 'block';
      marker_elem.innerHTML = "-&nbsp;";
   }
}

function ShowDiv( div_id )
{
   var elem = document.getElementById( div_id );
   if( elem == null )
      return;
   
   if( elem.style.display == '' && elem.offsetWidth != undefined && elem.offsetHeight != undefined )
      elem.style.display = ( elem.offsetWidth != 0 && elem.offsetHeight != 0 ) ? 'block' : 'none';
   
   if( !( elem.style.display == '' || elem.style.display == 'block' ) )
      elem.style.display = 'block';
}

function HideDiv( div_id )
{
   var elem = document.getElementById( div_id );
   if( elem == null )
      return;
   
   if( elem.style.display == '' && elem.offsetWidth != undefined && elem.offsetHeight != undefined )
      elem.style.display = ( elem.offsetWidth != 0 && elem.offsetHeight != 0 ) ? 'block' : 'none';
   
   if( elem.style.display == '' || elem.style.display == 'block' )
      elem.style.display = 'none';
}

function ShowEvasionElement( elem_name )
{
   var elem = document.getElementById( elem_name + "_li" )
   if( elem == null )
      return;

   if( elem.className == "evtree-closed" )
      elem.className = "evtree-open";
   else if( elem.className == "evtree-leaf-closed" )
      elem.className = "evtree-leaf-open";
}

function HideEvasionElement( elem_name )
{
   var elem = document.getElementById( elem_name + "_li" )
   if( elem == null )
        return;    

   if( elem.className == "evtree-open" )
      elem.className = "evtree-closed";
   else if( elem.className == "evtree-leaf-open" )
      elem.className = "evtree-leaf-closed";
}

function PresetsChosen( truth )
{
    if( truth )
    {
        ShowDiv( "evasion_presets_div" );
        HideDiv( "evasion_bg" );
    }
    else
    {
        ShowDiv( "evasion_bg" );
        HideDiv( "evasion_presets_div" );
    }
}

function ShowExploitOptions( attack_short_name )
{
    var elem = document.getElementById( "opt_" + attack_short_name + "_div" )
    elem.className = "opt_visible";
}

function HideExploitOptions( attack_short_name )
{
    var elem = document.getElementById( "opt_" + attack_short_name + "_div" )
    if( elem == null )
        return; //alert( "element " + attack_short_name + " not found " );
    else
        elem.className = "opt_hidden";
}

function SelectExploit( attack_short_name )
{
    var exploit_s = document.getElementById( 'exploits' );

    for( i=0; i<exploit_s.options.length; ++i )
    {
        if( exploit_s.options[ i ].value == attack_short_name )
        {
            exploit_s.selectedIndex = i;
            ExploitChanged();
            return;
        }
    }

    alert( "SelectExploit( " + attack_short_name + " ) - Attack not found!" );
}

function DisableExploitSelection()
{
    document.getElementById( 'exploits' ).disabled = true;
}

function EnableExploitSelection()
{
    document.getElementById( 'exploits' ).disabled = false;
}

function DisableAutomaticallyCloseShell()
{
    document.getElementById( 'global_auto_close_shell' ).disabled = true;
    document.getElementById( 'global_auto_close_shell' ).checked = false;
}

function EnableAutomaticallyCloseShell()
{
    document.getElementById( 'global_auto_close_shell' ).disabled = false;
}

function DisableSendCleanPayload()
{
    document.getElementById( 'global_clean' ).disabled = true;
    document.getElementById( 'global_clean' ).checked = false;
}

function EnableSendCleanPayload()
{
    document.getElementById( 'global_clean' ).disabled = false;
}

